package gov.va.med.domain.model;

import java.io.Serializable;
import java.util.Date;

import gov.va.med.framework.bean.ObjectHelper;

/**
 * Top-level abstraction for domain objects.
 * @author Jon Crater
 * @since 2.0
 * $Id: DomainObject.java,v 1.11 2005/08/05 11:05:58 slava.uchitel Exp $
 */
public class DomainObject implements Serializable, IPayload {
    
	/**
	 * Comment for <code>serialVersionUID</code>
	 */
	private static final long serialVersionUID = -4910838911038546169L;
	private Serializable id;
	private Long versionNumber;
    private Date createdDate;
    private Date modifiedDate;

    public DomainObject() {
    }
    
	public DomainObject(Serializable id, Long versionNumber, Date creationDate) {
		this.id = id;
		this.versionNumber = versionNumber;
		this.createdDate = creationDate;
	}

    public Serializable getId() {
	    return id;
    }

    /**
     * Should really be public so that the framework can make a clone of an object (for initializing a lazily loaded object)
     * @param id
     */
    public void setId(Serializable id) {
        this.id = id;
    }

    public Long getVersionNumber() {
	    return versionNumber;
    }
    
    /**
     * Should really be public so that the framework can make a clone of an object (for initializing a lazily loaded object)
     * @param versionNumber
     */
    public void setVersionNumber(Long versionNumber) {
	    this.versionNumber = versionNumber;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

	public Date getModifiedDate() {
		return modifiedDate;
	}

	public void setModifiedDate(Date modifiedDate) {
		this.modifiedDate = modifiedDate;
	}

	/**
     * Returns a string containing field level information for the specified
     * class.  This class uses introspection to inspect each field and each
     * field in each superclass.
     *
     * @return <code>String</code> containing the descriptive field level information
     */
    public String toString() {
        return ObjectHelper.toAString(this);
    }

    /**
     * Overrides to compare this object's id to the other object's id
     * Two objects with id of null are considered the same
     */
    public boolean equals(Object obj) {
        if (obj == null || obj instanceof DomainObject == false)
            return false;
        
        DomainObject other = (DomainObject)obj;
        if (this == obj || this.getId() == other.getId())
            return true;
        
        return getId() != null? getId().equals(other.getId()) : false;
    }

    /**
     * Used to safely initialize private fields of a cloned object 
     * @param clone
     */
    public void initializeClone(DomainObject clone) {
        clone.setId(getId());
        clone.setVersionNumber(getVersionNumber());
    }
    
}
